<?php
defined('ABSPATH') || exit;

$merchant_id  = get_option('agora_merchant_id');
$is_connected = !empty($merchant_id);
$last_sync    = get_option('agora_last_sync');
$sync_count   = (int) get_option('agora_last_sync_count', 0);
?>

<div class="agora-settings-wrap" style="max-width: 700px;">

    <?php if ($is_connected): ?>

        <div class="agora-status-card" style="background:#f0f9f0; border:1px solid #4caf50; border-radius:4px; padding:16px 20px; margin:20px 0;">
            <strong style="color:#2e7d32;"><?php esc_html_e('Connected to Agora', 'agora-agent-commerce'); ?></strong>
            <p style="margin:4px 0 0; color:#555;">
                <?php
                printf(
                    /* translators: %s: merchant ID */
                    esc_html__('Merchant ID: %s', 'agora-agent-commerce'),
                    '<code>' . esc_html($merchant_id) . '</code>'
                );
                ?>
            </p>
            <?php if ($last_sync): ?>
            <p style="margin:4px 0 0; color:#777; font-size:13px;">
                <?php
                printf(
                    /* translators: 1: date, 2: product count */
                    esc_html__('Last sync: %1$s · %2$d products synced', 'agora-agent-commerce'),
                    esc_html($last_sync),
                    $sync_count
                );
                ?>
            </p>
            <?php endif; ?>
        </div>

        <p>
            <button type="button" id="agora-sync-now" class="button button-secondary">
                <?php esc_html_e('Sync Catalog Now', 'agora-agent-commerce'); ?>
            </button>
            &nbsp;
            <button type="button" id="agora-disconnect" class="button" style="color:#b32d2e; border-color:#b32d2e;">
                <?php esc_html_e('Disconnect', 'agora-agent-commerce'); ?>
            </button>
        </p>
        <p id="agora-action-message" style="color:#555;"></p>

    <?php else: ?>

        <div class="agora-status-card" style="background:#fff; border:1px solid #ddd; border-radius:4px; padding:20px; margin:20px 0;">
            <h3 style="margin-top:0;"><?php esc_html_e('Connect your store to Agora', 'agora-agent-commerce'); ?></h3>
            <p>
                <?php
                printf(
                    /* translators: %s: link to agora.sh/merchants/signup */
                    esc_html__('First, %s to get your Agora API key. Then paste it below.', 'agora-agent-commerce'),
                    '<a href="https://agora.sh/merchants/signup" target="_blank" rel="noopener">' . esc_html__('register your store at agora.sh', 'agora-agent-commerce') . '</a>'
                );
                ?>
            </p>

            <table class="form-table" style="margin:0;">
                <tr>
                    <th scope="row">
                        <label for="agora_api_key_input"><?php esc_html_e('Agora API Key', 'agora-agent-commerce'); ?></label>
                    </th>
                    <td>
                        <input
                            type="password"
                            id="agora_api_key_input"
                            class="regular-text"
                            placeholder="agora_merch_xxxxxxxxxxxx"
                            autocomplete="new-password"
                        />
                        <p class="description">
                            <?php esc_html_e('Your agora_merch_* key from WooCommerce → Settings → Agora on agora.sh. Shown only once at registration.', 'agora-agent-commerce'); ?>
                        </p>
                    </td>
                </tr>
            </table>

            <p style="margin-top:16px;">
                <button type="button" id="agora-connect" class="button button-primary">
                    <?php esc_html_e('Save & Connect', 'agora-agent-commerce'); ?>
                </button>
            </p>
            <p id="agora-action-message" style="color:#555;"></p>
        </div>

    <?php endif; ?>

    <hr/>
    <p style="color:#777; font-size:12px;">
        <?php
        printf(
            /* translators: %s: link to agora.sh */
            esc_html__('Agora Agent Commerce v%s · %s', 'agora-agent-commerce'),
            esc_html(AGORA_PLUGIN_VERSION),
            '<a href="https://agora.sh" target="_blank" rel="noopener">agora.sh</a>'
        );
        ?>
    </p>

</div>

<script>
(function($) {
    // Connect — validate API key pasted from agora.sh/merchants/signup
    $('#agora-connect').on('click', function() {
        var btn    = $(this);
        var apiKey = $('#agora_api_key_input').val().trim();

        if (!apiKey) {
            $('#agora-action-message').text('<?php echo esc_js(__('Please paste your Agora API key.', 'agora-agent-commerce')); ?>');
            return;
        }

        btn.prop('disabled', true).text('<?php echo esc_js(__('Connecting…', 'agora-agent-commerce')); ?>');
        $('#agora-action-message').text('');

        $.post(ajaxurl, {
            action: 'agora_connect',
            nonce: agoraAdmin.nonce,
            api_key: apiKey,
        }, function(res) {
            if (res.success) {
                $('#agora-action-message').css('color', 'green').text(res.data.message);
                setTimeout(function() { location.reload(); }, 1500);
            } else {
                $('#agora-action-message').css('color', '#b32d2e').text(res.data.message);
                btn.prop('disabled', false).text('<?php echo esc_js(__('Save & Connect', 'agora-agent-commerce')); ?>');
            }
        });
    });

    // Sync Now
    $('#agora-sync-now').on('click', function() {
        var btn = $(this);
        btn.prop('disabled', true).text('<?php echo esc_js(__('Syncing…', 'agora-agent-commerce')); ?>');
        $('#agora-action-message').text('');

        $.post(ajaxurl, {
            action: 'agora_sync_now',
            nonce: agoraAdmin.nonce,
        }, function(res) {
            if (res.success) {
                $('#agora-action-message').css('color', 'green').text(res.data.message);
            } else {
                $('#agora-action-message').css('color', '#b32d2e').text(res.data.message);
            }
            btn.prop('disabled', false).text('<?php echo esc_js(__('Sync Catalog Now', 'agora-agent-commerce')); ?>');
        });
    });

    // Disconnect
    $('#agora-disconnect').on('click', function() {
        if (!confirm('<?php echo esc_js(__('Disconnect this store from Agora? Your products will no longer be visible to AI agents.', 'agora-agent-commerce')); ?>')) return;

        var btn = $(this);
        btn.prop('disabled', true).text('<?php echo esc_js(__('Disconnecting…', 'agora-agent-commerce')); ?>');

        $.post(ajaxurl, {
            action: 'agora_disconnect',
            nonce: agoraAdmin.nonce,
        }, function(res) {
            if (res.success) {
                location.reload();
            } else {
                $('#agora-action-message').css('color', '#b32d2e').text(res.data.message);
                btn.prop('disabled', false).text('<?php echo esc_js(__('Disconnect', 'agora-agent-commerce')); ?>');
            }
        });
    });
})(jQuery);
</script>
